USE OLAP
--Filtering by city
SELECT * FROM profit_by_order_method_type
WHERE city = 'Sydney'

--use table-based funcitons 
go
CREATE FUNCTION profit_by_order_method_type_filtered (@city varchar(255)) RETURNS table AS
RETURN SELECT order_method_type
       ,format(sum(profit),'C') as total_profit --call this column total_profit
FROM sales_enriched
WHERE retailer_city = @city
GROUP BY order_method_type
go

--Then we can easily filter by city
SELECT * FROM profit_by_order_method_type_filtered('Sydney')
